/**
 * Conversation window
 * @param {Core} owner
 * @param {int} id_user
 */
var Conversation = new Class({
  options: {width: 700, height: 500},
	owner: null,
  el: null,
	el_input: null,
	el_message_prototype: null,
  el_transfer_prototype: null,
	id_user: null,
	window: null,
	native_window: null,
	messages: new Array(),
  transfers_outgoing: new Array(),
  transfers_incoming: new Array(),
	server: null,
  
  initialize: function(owner, id_user){
		this.owner = owner;
		this.id_user = id_user;
		
		this.server = new Server({background: true});
		
		var tpl = new Template("message");    
		this.el_message_prototype = new Element('div').adopt(tpl.xml).getFirst();
		
		var tpl = new Template("filetransfer");    
    this.el_transfer_prototype = new Element('div').adopt(tpl.xml).getFirst();
		
		var title = "CLIM - " + this.owner.user.contacts.get(id_user).nick;
		
		// create new window
		this.window = window.open("conversation.html", title, "height=" + this.options.height + ", width=" + this.options.width);
		this.native_window = this.window.nativeWindow;
		
		this.window.document.title = title;
		this.window.opener = this;
		
		// assign onClose event
		this.native_window.addEventListener(air.Event.CLOSE, this.onClose.bind(this));
  },
	
	//activate and show the new conversation window 
	open: function(){
	  this.native_window.activate(); 
	},
	
	close: function(){
		this.native_window.close();
	},
	
	// raised when new conversation window was opened
	onLoad: function(){
		this.el = $(this.window.document.body.getElement('div#_main'));
		this.el_input = this.el.getElementById('input_text');
		
		var t = this;
		this.el_input.addEvent('keydown', function(e){
			var event = new Event(e);
			if(e.key == 'enter'){
				event.stop();
				if(!e.control){
					t.submit();
					
				} else {
					this.value += '\n';
					this.selectionStart = this.value.length;
					this.selectionEnd = this.selectionStart;					
				}
			}
		});
		
		this.reload();
		this.el_input.focus();
		this.initDragDrop();
		this.fireEvent('onload');
	},
	
	// end the conversation when user closes the window
	onClose: function(){
		if ($defined(this.owner.user)) this.owner.user.closeConversation(this.id_user);
	},
	
	initDragDrop: function(){  
    this.el.addEventListener("dragenter", this.dragEnterOverHandler.bind(this)); 
    this.el.addEventListener("dragover", this.dragEnterOverHandler.bind(this)); 
    this.el.addEventListener("drop", this.dropHandler.bind(this));
  },

  dragEnterOverHandler: function(event){
    if (this.dropAccepts(event)) event.preventDefault();
  },
 
  dropHandler: function(event){
		if(!this.dropAccepts(event)) return;
		
		var dropfiles = event.dataTransfer.getData('application/x-vnd.adobe.air.file-list');
		for(var i in dropfiles){
      this.sendFile(dropfiles[i]);
		}
  },
	
	// whether to accept this type of drag & drop Event
	dropAccepts: function(event){
		if (event.dataTransfer.types != 'application/x-vnd.adobe.air.file-list') return false;
		var dropfiles = event.dataTransfer.getData('application/x-vnd.adobe.air.file-list');
    for(var i in dropfiles){
      if (dropfiles[i].isDirectory) return false;
    }
		return true;
	},
	
	reload: function(){
		if(!$defined(this.el)) return;
		
		this.messages.each(function(value, key){
			if($defined(value.shown) && value.shown) return;
			
			// zkopirujeme prototyp spravy
			var el = this.el_message_prototype.clone(true, true);			
			
			// naplnime spravu
			var time = new DateTime(value.time);
			
			if (value.type == 'sent') {
	  		el.getElement('span.nick').set('html', this.owner.user.info.nick);
		  } else {
		  	el.getElement('span.nick').set('html', this.owner.user.contacts.get(value.id_user).nick);
		  }
			el.getElement('span.time').set('html', time.format());
			el.getElement('div.body').set('html', value.text.replace(/\r?\n/g, '</br>'));
			
			this.el.getElement('#messages_panel').adopt(el);
			
			this.messages[key].shown = true;
		}, this);
		
    this.transfers_incoming.each(function(value, key){
      if($defined(value.shown) && value.shown) return;
			
			this.el.getElement('#messages_panel').adopt(value.el);
			this.transfers_incoming[key].shown = true;
		}, this);
      
    this.transfers_outgoing.each(function(value, key){
      if($defined(value.shown) && value.shown) return;
      
      this.el.getElement('#messages_panel').adopt(value.el);
      this.transfers_outgoing[key].shown = true;
    }, this);  
	},
	
	// send message
	submit: function(){
		var text = this.el_input.value;
		
		// odstranime nepotrebne konce riadkov a entery (len aby sme zistili ci potom neostane prazdny text)
		var test_text = text.replace(/\n|\0|\f|\r|\t|\v| /gm, "");
		if(test_text == '') return;
		this.el_input.value = '';
				
    this.server.request({'action': 'send_message', 'args': {'text': text, 'id_user_contact': this.id_user}}, function(response){
      if(!$defined(response)){
        showError('Chyba: nepodarilo sa odoslať správu');
				if(this.el_input.value == '') this.el_input.value = text;
				
      } else {        
				// response should be the submit time in seconds
				if(!$empty(response)){
					// 2010-05-03
					//this.messages.push({'type': 'sent', 'id_user': this.id_user, 'text': response.text, 'time': response.time});
					//this.reload();
				}
      }
    }.bind(this));
    
		// 2010-05-03 - show outgoing message right after hitting enter
	  this.messages.push({'type': 'sent', 'id_user': this.id_user, 'text': text, 'time': DateTime.now()});
	  this.reload();
	},
	
  addIncomingMessage: function(msg){
    this.messages.push({'type': 'recieved', 'id_user': msg.id_user_contact, 'text': msg.text, 'time': msg.sent_time});
    this.reload();
  },
  
	addIncomingTransfer: function(value){
		transfer = {};
		transfer.type = 'incoming';
		transfer.id_transfer = value.id;
		transfer.id = this.transfers_incoming.length; 
    transfer.id_user = this.id_user;
		transfer.filepath = null;
		transfer.filename = value.name;
    transfer.time = value.sent_time;
    transfer.started = null;
    transfer.finished = null;
    transfer.percent = 0;
    transfer.transferred = 0;
		transfer.size = value.size;
		
    this.transfers_incoming[transfer.id] = transfer;
    this.addTransferEl(transfer);
	},
	
	startIncomingTransfer: function(transfer){
    var dir = air.File.desktopDirectory.resolvePath(transfer.filename);
    dir.browseForSave("Uložiť prijatý súbor ako");
    dir.addEventListener(air.Event.SELECT, function(event){
			this.saveFileHandler(event, transfer);
		}.bind(this));
	},
  
  saveFileHandler: function(event, transfer){
    transfer.started = DateTime.now(true);
		transfer.finished = null;
		transfer.transferred = 0;
    transfer.el.removeClass('waiting');
    this.updateTransferEl('incoming', transfer.id);
    
    this.owner.server.request({'action': 'download_transfer', 'args': {'id_transfer': transfer.id_transfer}}, function(response){
      if($defined(response) && $defined(response.url)){
				this.downloadFile(event.target, response.url, transfer);	
      } else {
        showError('Chyba: súbor \'' + transfer.filename + '\'sa nepodarilo stiahnuť.');
        transfer.failed = true;
        transfer.el.addClass('waiting');
        this.updateTransferEl('incoming', transfer.id);
      } 
    }.bind(this), {background: true});
  },
	
	downloadFile: function(file, url, transfer){
    this.owner.server.downloadFile(
      url, file,
      
      function(event){ // on complete
        if (transfer.transferred == transfer.size) {
					transfer.complete = true;
				} else {
					transfer.failed = true;
				}
        transfer.percent = transfer.transferred / transfer.size * 100;
        if (!$defined(transfer.finished)) transfer.finished = DateTime.now(true);
        this.updateTransferEl('incoming', transfer.id);
      }.bind(this),
      
      function(event){ // on progress update
        transfer.transferred = event.bytesLoaded;
        transfer.percent = transfer.transferred / transfer.size * 100;
        if (event.bytesTotal == event.bytesLoaded) transfer.finished = DateTime.now(true);
        this.updateTransferEl('incoming', transfer.id);
      }.bind(this),
      
      function(event){ // on error
        transfer.failed = true; 
        if (!$defined(transfer.finished)) transfer.finished = DateTime.now(true);
        this.updateTransferEl('incoming', transfer.id);
      }.bind(this),
      
			// options
      {background: true}
    );
	},
	
	sendFile: function(file){
    // TODO check file size before uploading
		
		// prepare transfer info
    var transfer = {};
    transfer.type = 'outgoing';
		transfer.id = this.transfers_outgoing.length;
		transfer.id_user = this.id_user;
		transfer.filepath = file.nativePath;
		transfer.filename = transfer.filepath.substr(transfer.filepath.lastIndexOf(air.File.separator)+1);
		transfer.time = DateTime.now(true);
		transfer.started = transfer.time;
		transfer.finished = null;
		transfer.percent = 0;
		transfer.transferred = 0;
		transfer.size = 0;
		
    this.transfers_outgoing[transfer.id] = transfer;
		var transfer = this.transfers_outgoing[transfer.id];
    this.addTransferEl(transfer);
				
		this.owner.server.uploadFile(
		  {'action': 'send_file', 'args': {'id_user_contact': this.id_user}},
		  file.nativePath,
			
		  function(response){ // on complete
				if (!$defined(response) || $defined(response.error)){
					transfer.failed = true;
				} else {
          transfer.complete = true;
				}
        if (!$defined(transfer.finished)) transfer.finished = DateTime.now(true);
        this.updateTransferEl('outgoing', transfer.id);
		  }.bind(this),
			
		  function(event){ // on progress update
		    transfer.size = event.bytesTotal;
				transfer.transferred = event.bytesLoaded;
				transfer.percent = event.bytesLoaded / event.bytesTotal * 100;
				if (event.bytesTotal == event.bytesLoaded) transfer.finished = DateTime.now(true);
				this.updateTransferEl('outgoing', transfer.id);
		  }.bind(this),
			
		  function(event){ // on error
        transfer.failed = true; 
        if (!$defined(transfer.finished)) transfer.finished = DateTime.now(true);
				this.updateTransferEl('outgoing', transfer.id);
		  }.bind(this),
			
			// options
			{background: true}
		);
	},
	
	addTransferEl: function(transfer){
    // zkopirujeme prototyp sablony informujucej o prenose
    var el = this.el_transfer_prototype.clone(true, true);      
    
    // naplnime sablonu
    if (transfer.type == 'outgoing') {
      el.getElement('.nick').set('html', this.owner.user.info.nick);
    } else {
      el.getElement('.nick').set('html', this.owner.user.contacts.get(transfer.id_user).nick);
			
			if (!$defined(transfer.started)) {
        el.addClass('waiting');
				
				el.getElement('.accept_link').addEvent('click', function(){
					this.startIncomingTransfer(transfer);
				}.bind(this));
			}
    }
		
		// Add CSS classes
		el.addClass(transfer.type);
		el.id = 'filetransfer_' + transfer.type + '_' + transfer.id;
		
    el.getElement('.time').set('html', new DateTime(transfer.time).format());
    el.getElement('.filename').set('html', transfer.filename);
		el.getElement('.percent').set('html', Math.round(transfer.percent));
    el.getElement('.transferred').set('html', transfer.transferred);
		el.getElement('.size').set('html', transfer.size);
		
		transfer.el = el;
		transfer.shown = false;
		this.reload();
	},
	
	updateTransferEl: function(type, id){
		if (type == 'outgoing') {
			var transfer = this.transfers_outgoing[id];
		} else {
			var transfer = this.transfers_incoming[id];
		}
		
		this.setElementPropertyEl(transfer.el, 'percent', Math.round(transfer.percent));
		this.setElementPropertyEl(transfer.el, 'transferred', transfer.transferred);
		this.setElementPropertyEl(transfer.el, 'size', transfer.size);
		
		if ($defined(transfer.finished)) {
			var speed = this.calculateTransferSpeed(transfer.started, transfer.finished, transfer.transferred);
		} else {
			var speed = this.calculateTransferSpeed(transfer.started, DateTime.now(true), transfer.transferred);
		}
		
    this.setElementPropertyEl(transfer.el, 'speedbs', Math.round(speed));
    this.setElementPropertyEl(transfer.el, 'speedkbs', Math.round(speed / 1024));
    this.setElementPropertyEl(transfer.el, 'speedmbs', Math.round(speed / 1024 / 1024));
		
    // Add CSS classes
		if ($defined(transfer.complete) && transfer.complete){
			transfer.el.addClass('complete');
		} else {
			transfer.el.removeClass('complete');
		}
		
    if ($defined(transfer.failed) && transfer.failed){
      transfer.el.addClass('failed');
    } else {
      transfer.el.removeClass('failed');
    }
	},
	
	// Calculete data transfer speed by start/end micro-timestamp and bytes transfered
	calculateTransferSpeed: function(start, end, bytes){
		if (end == start) return bytes;
		return bytes / (end - start) * 1000;
	},
	
	// Sets element sub-element with classname .property if exists
	setElementPropertyEl: function(el, property, html){
		var propel = el.getElement('.' + property);
		if (!$defined(propel)) return false;
		propel.set('html', html);
	}
});

Conversation.implement(new Events);